<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:inr="http://mycompany.com/mynamespace">
    <xsl:include href="../format.xsl"/>
    <xsl:param name="xslRootDirectory" select="inr:xslRootDirectory"/>
    <!-- List Coordinates with Station Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="inr:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">List Coordinates with Station Report</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en"></h2>
                                <p lang="en">
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="0" width="30%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Verkefni:</th>
                                            <td align="left"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Skraarnafn:</th>
                                            <td align="left"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Gert/dags:</th>
                                            <td align="left"><xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <table class="margin" cellpadding="2" cellspacing="4" width="30%">
                                    <tbody>
                                        <xsl:for-each select="HorizontalAlignment">
                                            <tr>
                                                <th align="right" lang="en">Veglina:</th>
                                                <td align="left" colspan="4"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en">Stod </th>                  
                                                <th class="underline" lang="en">Austur</th>
                                                <th class="underline" lang="en">Nordur</th>
                                            </tr>
                                            <xsl:for-each select="HorizontalElements">
                                                <xsl:apply-templates/>
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!--  Element Point Data -->
    <xsl:template match="Start | HorizontalLine/PI">
        <tr>
            <td class="sidepad" align="center" nowrap="nowrap">
                <xsl:value-of select="inr:stationFormat(number(station/@externalStation), $xslStationFormat, $xslStationPrecision, string(station/@externalStationName))"/>
            </td>
            <td class="sidepad" align="center"><xsl:value-of select="inr:eastingFormat(number(@easting), $xslEastingPrecision)"/></td>
            <td class="sidepad" align="center"><xsl:value-of select="inr:northingFormat(number(@northing), $xslNorthingPrecision)"/></td>
        </tr>
    </xsl:template>
    <!-- Event Point Data -->
    <xsl:template match="HorizontalLine | HorizontalCircle | HorizontalSpiral">
        <xsl:variable name="startStation" select="Start/station/@internalStation"/>
        <xsl:variable name="endStation" select="End/station/@internalStation"/>
        <xsl:apply-templates/>
        <xsl:for-each select="../../HorizontalEventPoints">
            <xsl:variable name="list1" select="*/HorizontalEventPoint[GeometryPoint/station/@internalStation &gt; $startStation]"/>
            <xsl:for-each select="$list1[GeometryPoint/station/@internalStation &lt; $endStation]">
                <xsl:sort data-type="number" select="./GeometryPoint/station/@internalStation"/>
                <tr>
                    <td class="sidepad" align="center">
                        <xsl:value-of select="inr:stationFormat(number(GeometryPoint/station/@externalStation), $xslStationFormat, $xslStationPrecision, string(GeometryPoint/station/@externalStationName))"/>
                    </td>
                    <td class="sidepad" align="left">
                        <xsl:if test="@eventType='xyEvent'">N+E EVT</xsl:if>
                        <xsl:if test="@eventType='stationEvent'">S+O EVT</xsl:if>
                    </td>
                    <td class="sidepad" align="center">
                        <xsl:value-of select="inr:eastingFormat(number(GeometryPoint/@easting), $xslEastingPrecision)"/>
                    </td>
                    <td class="sidepad" align="center">
                        <xsl:value-of select="inr:northingFormat(number(GeometryPoint/@northing), $xslNorthingPrecision)"/>
                    </td>
                    <td class="sidepad" align="center">
                        <xsl:value-of select="inr:elevationFormat(number(GeometryPoint/@elevation), $xslElevationPrecision)"/>
                    </td>
                </tr>
            </xsl:for-each>
        </xsl:for-each>
        <xsl:if test="position() = last()">
            <xsl:call-template name="lastPoint"/>
        </xsl:if>
    </xsl:template>
    <!--  Last Point Data -->
    <xsl:template name="lastPoint">
        <tr>
            <td class="sidepad" align="center" nowrap="nowrap">
                <xsl:value-of select="inr:stationFormat(number(End/station/@externalStation), $xslStationFormat, $xslStationPrecision, string(station/@externalStationName))"/>
            </td>
            <td class="sidepad" align="center"><xsl:value-of select="inr:eastingFormat(number(End/@easting), $xslEastingPrecision)"/></td>
            <td class="sidepad" align="center"><xsl:value-of select="inr:northingFormat(number(End/@northing), $xslNorthingPrecision)"/></td>
        </tr>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
                You must include at least one horizontal alignment and/or one Cogo point in the <em>Include
                </em> fields on the <em>Tools &gt; XML Reports &gt; Geometry</em> command to get results 
                from this report.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
